/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.BorderPainter;
import net.sf.paperclips.GridMargins;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

class DefaultGridMargins
implements GridMargins {
    private final BorderPainter border;
    private final Point cellSpacing;
    private final Rectangle cellPadding;
    private final int headerClosedSpacing;
    private final int headerOpenSpacing;
    private final int footerClosedSpacing;
    private final int footerOpenSpacing;

    DefaultGridMargins(BorderPainter border, Point cellSpacing, Rectangle cellPadding, int headerClosedSpacing, int headerOpenSpacing, int footerClosedSpacing, int footerOpenSpacing) {
        this.border = border;
        this.cellSpacing = cellSpacing;
        this.cellPadding = cellPadding;
        this.headerClosedSpacing = headerClosedSpacing;
        this.headerOpenSpacing = headerOpenSpacing;
        this.footerClosedSpacing = footerClosedSpacing;
        this.footerOpenSpacing = footerOpenSpacing;
    }

    public int getLeft() {
        return this.border.getLeft() + this.cellPadding.x;
    }

    public int getHorizontalSpacing() {
        return this.cellSpacing.x + this.cellPadding.x + this.cellPadding.width;
    }

    public int getRight() {
        return this.border.getRight() + this.cellPadding.width;
    }

    public int getHeaderTop() {
        return this.border.getTop(false) + this.cellPadding.y;
    }

    public int getHeaderVerticalSpacing() {
        return this.cellSpacing.y + this.cellPadding.y + this.cellPadding.height;
    }

    public int getBodyTop(boolean headerPresent, boolean open) {
        return headerPresent ? (open ? this.headerOpenSpacing : this.headerClosedSpacing + this.cellPadding.y) : (open ? this.border.getTop(true) : this.border.getTop(false) + this.cellPadding.y);
    }

    public int getBodyVerticalSpacing() {
        return this.cellSpacing.y + this.cellPadding.y + this.cellPadding.height;
    }

    public int getBodyBottom(boolean footerPresent, boolean open) {
        return footerPresent ? (open ? this.footerOpenSpacing : this.footerClosedSpacing + this.cellPadding.height) : (open ? this.border.getBottom(true) : this.border.getBottom(false) + this.cellPadding.height);
    }

    public int getFooterVerticalSpacing() {
        return this.cellSpacing.y + this.cellPadding.y + this.cellPadding.height;
    }

    public int getFooterBottom() {
        return this.border.getBottom(false) + this.cellPadding.height;
    }
}

