/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.io.InputStream;
import net.sf.paperclips.DefaultGridLook;
import net.sf.paperclips.EmptyPrint;
import net.sf.paperclips.GridLook;
import net.sf.paperclips.GridPrint;
import net.sf.paperclips.ImagePrint;
import net.sf.paperclips.LayerPrint;
import net.sf.paperclips.Print;
import net.sf.paperclips.PrintIterator;
import net.sf.paperclips.TextPrint;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public abstract class FactoryPrint
implements Print {
    private Print print;

    public Print getPrint() {
        if (this.print == null) {
            this.print = this.createPrint();
        }
        return this.print;
    }

    public PrintIterator iterator(Device device, GC gc) {
        return this.getPrint().iterator(device, gc);
    }

    protected abstract Print createPrint();

    protected String convertToString(Object obj) {
        return obj == null ? "" : obj.toString();
    }

    protected FontData getDefaultTextFont() {
        return TextPrint.DEFAULT_FONT_DATA;
    }

    protected FontData getDefaultLabelFont() {
        return TextPrint.DEFAULT_FONT_DATA;
    }

    protected int getDefaultGridSpacing() {
        return 2;
    }

    protected TextPrint text(Object obj) {
        return this.text(this.convertToString(obj));
    }

    protected TextPrint text(Object obj, int align) {
        return this.text(this.convertToString(obj), align);
    }

    protected TextPrint text(String text) {
        return this.text(text, -1);
    }

    protected TextPrint text(String text, int align) {
        return new TextPrint(text, this.getDefaultTextFont(), align);
    }

    protected TextPrint label(String text) {
        return this.label(text, -1);
    }

    protected TextPrint label(String text, int align) {
        return new TextPrint(text, this.getDefaultLabelFont(), align);
    }

    protected Point getDefaultImageDPI() {
        return new Point(300, 300);
    }

    protected ImageData getImageData(String filename) {
        return new ImageData(filename);
    }

    protected ImagePrint image(String filename) {
        return this.image(filename, this.getDefaultImageDPI());
    }

    protected ImagePrint image(String filename, Point dpi) {
        return new ImagePrint(this.getImageData(filename), dpi);
    }

    protected ImagePrint image(InputStream is) {
        return this.image(is, this.getDefaultImageDPI());
    }

    protected ImagePrint image(InputStream is, Point dpi) {
        return new ImagePrint(new ImageData(is), dpi);
    }

    protected ImagePrint image(ImageData imageData) {
        return this.image(imageData, this.getDefaultImageDPI());
    }

    protected ImagePrint image(ImageData imageData, Point dpi) {
        return new ImagePrint(imageData, dpi);
    }

    protected GridPrint grid(String columns) {
        return this.grid(columns, this.getDefaultGridSpacing());
    }

    protected GridPrint grid(String columns, int spacing) {
        return new GridPrint(columns, (GridLook)new DefaultGridLook(spacing, spacing));
    }

    protected LayerPrint layer() {
        return new LayerPrint();
    }

    protected EmptyPrint empty() {
        return this.empty(0, 0);
    }

    protected EmptyPrint empty(int width, int height) {
        return new EmptyPrint(width, height);
    }
}

