/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.paperclips.PaperClips;
import net.sf.paperclips.internal.PaperClipsUtil;
import net.sf.paperclips.internal.Util;

public class GridColumn {
    public static final int DEFAULT_ALIGN = 16384;
    public static final int DEFAULT_SIZE = -1;
    public static final int DEFAULT_WEIGHT = 0;
    public final int size;
    public final int align;
    public final int weight;
    private static final Pattern LEFT_ALIGN_PATTERN = Pattern.compile("^l(eft)?$", 2);
    private static final Pattern CENTER_ALIGN_PATTERN = Pattern.compile("^c(enter)?$", 2);
    private static final Pattern RIGHT_ALIGN_PATTERN = Pattern.compile("^r(ight)?$", 2);
    private static final Pattern ANY_ALIGN_PATTERN = Pattern.compile("^l(eft)?|c(enter)?|r(ight)?$", 2);
    private static final Pattern DEFAULT_SIZE_PATTERN = Pattern.compile("^d(ef(ault)?)?$", 2);
    private static final Pattern PREFERRED_SIZE_PATTERN = Pattern.compile("^p(ref(erred)?)?", 2);
    private static final Pattern EXPLICIT_SIZE_PATTERN = Pattern.compile("^(\\d+(\\.\\d+)?)\\s*(pt|in(ch)?|mm|cm)?$", 2);
    private static final Pattern WEIGHTLESS_PATTERN = Pattern.compile("n(one)?", 2);
    private static final Pattern WEIGHTED_PATTERN = Pattern.compile("(g(row)?)(\\((\\d+)\\))?", 2);

    public GridColumn(int align, int size, int weight) {
        this.align = GridColumn.checkAlign(align);
        this.size = GridColumn.checkSize(size);
        this.weight = GridColumn.checkWeight(weight);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.align;
        result = 31 * result + this.size;
        result = 31 * result + this.weight;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GridColumn other = (GridColumn)obj;
        if (this.align != other.align) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        return this.weight == other.weight;
    }

    private static int checkAlign(int align) {
        if ((align = PaperClipsUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072, -1}, 0)) == 0) {
            PaperClips.error(5, "Alignment argument must be one of SWT.LEFT, SWT.CENTER, SWT.RIGHT, or SWT.DEFAULT");
        }
        if (align == -1) {
            return 16384;
        }
        return align;
    }

    private static int checkSize(int size) {
        if (size != -1 && size != 0 && size <= 0) {
            PaperClips.error(5, "Size argument must be SWT.DEFAULT, GridPrint.PREFERRED, or > 0");
        }
        return size;
    }

    private static int checkWeight(int grow) {
        if (grow < 0) {
            PaperClips.error(5, "Weight argument must be >= 0");
        }
        return grow;
    }

    public static GridColumn parse(String spec) {
        Util.notNull(spec);
        String[] matches = spec.split("\\s*:\\s*");
        if (matches.length == 0) {
            PaperClips.error(5, "Missing column spec");
        }
        int align = 16384;
        int size = -1;
        int grow = 0;
        if (matches.length == 1) {
            size = GridColumn.parseSize(matches[0]);
        } else if (matches.length == 2) {
            if (GridColumn.isAlign(matches[0])) {
                align = GridColumn.parseAlign(matches[0]);
                size = GridColumn.parseSize(matches[1]);
            } else {
                size = GridColumn.parseSize(matches[0]);
                grow = GridColumn.parseWeight(matches[1]);
            }
        } else if (matches.length == 3) {
            align = GridColumn.parseAlign(matches[0]);
            size = GridColumn.parseSize(matches[1]);
            grow = GridColumn.parseWeight(matches[2]);
        }
        return new GridColumn(align, size, grow);
    }

    private static boolean isAlign(String alignmentString) {
        return ANY_ALIGN_PATTERN.matcher(alignmentString).matches();
    }

    private static int parseAlign(String alignmentString) {
        if (LEFT_ALIGN_PATTERN.matcher(alignmentString).matches()) {
            return 16384;
        }
        if (CENTER_ALIGN_PATTERN.matcher(alignmentString).matches()) {
            return 0x1000000;
        }
        if (RIGHT_ALIGN_PATTERN.matcher(alignmentString).matches()) {
            return 131072;
        }
        PaperClips.error(5, "Unknown alignment \"" + alignmentString + "\"");
        return 0;
    }

    private static int parseSize(String sizeString) {
        if (DEFAULT_SIZE_PATTERN.matcher(sizeString).matches()) {
            return -1;
        }
        if (PREFERRED_SIZE_PATTERN.matcher(sizeString).matches()) {
            return 0;
        }
        Matcher matcher = EXPLICIT_SIZE_PATTERN.matcher(sizeString);
        if (matcher.matches()) {
            return (int)Math.ceil(GridColumn.convertToPoints(Double.parseDouble(matcher.group(1)), matcher.group(3)));
        }
        PaperClips.error(5, "Unknown size pattern: \"" + sizeString + "\"");
        return 0;
    }

    private static double convertToPoints(double value, String unit) {
        if (unit == null || unit.length() == 0 || unit.equalsIgnoreCase("pt")) {
            return value;
        }
        if (unit.equalsIgnoreCase("in") || unit.equalsIgnoreCase("inch")) {
            return 72.0 * value;
        }
        if (unit.equalsIgnoreCase("cm")) {
            return 72.0 * value / 2.54;
        }
        if (unit.equalsIgnoreCase("mm")) {
            return 72.0 * value / 25.4;
        }
        PaperClips.error(5, "Unknown unit \"" + unit + "\".");
        return 0.0;
    }

    private static int parseWeight(String weightString) {
        if (WEIGHTLESS_PATTERN.matcher(weightString).matches()) {
            return 0;
        }
        Matcher matcher = WEIGHTED_PATTERN.matcher(weightString);
        if (matcher.matches()) {
            String weight = matcher.group(4);
            return weight == null ? 1 : Integer.parseInt(weight);
        }
        PaperClips.error(5, "Illegal grow pattern: \"" + weightString + "\"");
        return 0;
    }

    GridColumn copy() {
        return new GridColumn(this.align, this.size, this.weight);
    }
}

