/*
 * Decompiled with CFR 0.152.
 */
package net.sf.paperclips;

import net.sf.paperclips.AbstractBorderPainter;
import net.sf.paperclips.LineBorder;
import net.sf.paperclips.internal.ResourcePool;
import net.sf.paperclips.internal.Util;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;

class LineBorderPainter
extends AbstractBorderPainter {
    private final Device device;
    private final RGB rgb;
    private final Point lineWidth;
    private final Point borderWidth;

    LineBorderPainter(LineBorder border, Device device, GC gc) {
        Util.notNull(border, device, gc);
        this.rgb = border.rgb;
        this.device = device;
        int lineWidthPoints = border.getLineWidth();
        int borderWidthPoints = border.getGapSize();
        Point dpi = device.getDPI();
        this.lineWidth = new Point(Math.round((float)(lineWidthPoints * dpi.x) / 72.0f), Math.round((float)(lineWidthPoints * dpi.y) / 72.0f));
        this.borderWidth = new Point(Math.round((float)(borderWidthPoints * dpi.x) / 72.0f), Math.round((float)(borderWidthPoints * dpi.y) / 72.0f));
    }

    public int getLeft() {
        return this.borderWidth.x;
    }

    public int getRight() {
        return this.borderWidth.x;
    }

    public int getTop(boolean open) {
        return open ? 0 : this.borderWidth.y;
    }

    public int getBottom(boolean open) {
        return open ? 0 : this.borderWidth.y;
    }

    public void paint(GC gc, int x, int y, int width, int height, boolean topOpen, boolean bottomOpen) {
        Color oldColor = gc.getBackground();
        try {
            gc.setBackground(ResourcePool.forDevice(this.device).getColor(this.rgb));
            gc.fillRectangle(x, y, this.lineWidth.x, height);
            gc.fillRectangle(x + width - this.lineWidth.x, y, this.lineWidth.x, height);
            if (!topOpen) {
                gc.fillRectangle(x, y, width, this.lineWidth.y);
            }
            if (!bottomOpen) {
                gc.fillRectangle(x, y + height - this.lineWidth.y, width, this.lineWidth.y);
            }
        }
        finally {
            gc.setBackground(oldColor);
        }
    }

    public Point getOverlap() {
        return new Point(this.lineWidth.x, this.lineWidth.y);
    }

    public void dispose() {
    }
}

